<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/xsl/v2/flattener-v2-recursive-in depth.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output encoding="utf-8" method="xml" indent="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/xsl:stylesheet">

		<!-- create xsl:stylesheet element -->
		<xsl:element name="xsl:stylesheet">

			<!-- copy attributes and namespaces of the starting stylesheet -->
			<xsl:copy-of select="./namespace::*"/>
			<xsl:copy-of select="./attribute::*"/>

			<!-- copy the attributes and namespaces of all included stylesheets -->
			<xsl:apply-templates select="xsl:import|xsl:include" mode="flatten-attributes"/>
			
			<!-- copy the content of all included stylesheets and the content of the starting stylesheet -->
			<xsl:apply-templates select="*" mode="flatten-stylesheets"/>

		</xsl:element>
    </xsl:template>

	<xsl:template match="xsl:import|xsl:include" mode="flatten-attributes">
		<xsl:variable name="path" select="@href"/>
		<xsl:variable name="stylesheet" select="document($path)/xsl:stylesheet"/>

		<!-- copy the attributes and namespaces of the imported stylesheet -->
		<xsl:copy-of select="$stylesheet/namespace::*"/>
		<xsl:copy-of select="$stylesheet/attribute::*"/>
		
		<!-- recursively for all further imported stylesheets  -->
		<xsl:apply-templates select="$stylesheet/xsl:import|xsl:include" mode="flatten-attributes"/>
    </xsl:template>

	<xsl:template match="xsl:import|xsl:include" mode="flatten-stylesheets">
		<xsl:param name="absolute" select="''"/>
		<xsl:param name="imported" select="''"/>

		<xsl:variable name="path" select="@href"/>
		<xsl:variable name="stylesheet" select="document($path)/xsl:stylesheet"/>

		<!-- root management -->
		<xsl:choose>
			<xsl:when test="starts-with($path,'../')">
				
			</xsl:when>
			<xsl:when test="contains($path,'/')">
				
			</xsl:when>
		</xsl:choose>

		<xsl:variable name="absolute-path" select="concat($absolute,$path)"/>
		<log><xsl:value-of select="$imported"/></log>
		<!-- already imported stylesheet management -->
		<xsl:choose>
			<xsl:when test="contains($imported,$absolute-path)">
				<log>!! DO NOTHING !!</log>
				<!-- do nothing -->
			</xsl:when>
			<xsl:otherwise>
				<!-- recursively import all further stylesheets -->
				<xsl:apply-templates select="$stylesheet/*" mode="flatten-stylesheets">
					<xsl:with-param name="absolute" select="$absolute"/>
					<xsl:with-param name="imported" select="concat($imported,';',$absolute-path)"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>

    </xsl:template>

	<xsl:template match="*[name() != 'xsl:import' and name() != 'xsl:include']" mode="flatten-stylesheets">
		<xsl:copy-of select="."/>
	</xsl:template>

</xsl:stylesheet>